#declare RandGen = seed(128);
#declare One = box {<-1/16,1/2,3/8> <1/16,-1/2,-3/8> scale 1/4}
#declare Zero = difference {sphere {0 1 scale <1/4,1,3/8>} sphere {0 1/2 scale <1/4,1,3/8>} scale 1/4}

#macro Bit_Stream(Cols,Rows,Swirls,Color)
 union {
  #declare Col = 0-Cols/2;
  #while (Col <= Cols/2)
   #declare Row = 0-Rows/2;
   #while (Row <= Rows/2)
    intersection {
     object {
      #if (rand(RandGen)>1/2)
       One
      #else
       Zero
      #end
     }
     box {<-1/4,-1/128,1/4> <1/4,1/128,-1/4>}
     translate <Col,-4,Row>
     rotate <0,0,Row*360*Swirls/Rows>
    }
    #declare Row = Row + 1/4;
   #end
   #declare Col = Col + 1/4;
  #end
  pigment {Color}
  finish {ambient 1}
 }
#end

object {
 Bit_Stream(4,256,2,pigment {rgb <0,1,0>})
 rotate <0,0,0>
}
object {
 Bit_Stream(4,256,2,pigment {rgb <1,1,0>})
 rotate <0,0,60-2>
}
object {
 Bit_Stream(4,256,2,pigment {rgb <1,0,0>})
 rotate <0,0,120+2>
}
object {
 Bit_Stream(4,256,2,pigment {rgb <1,0,1>})
 rotate <0,0,180>
}
object {
 Bit_Stream(4,256,2,pigment {rgb <0,0,1>})
 rotate <0,0,240>
}
object {
 Bit_Stream(4,256,2,pigment {rgb <0,1,1>})
 rotate <0,0,300>
}

//Output_File_Name="cyberspace environment map" +UA +W4096 +H3072 -d

//cylinder {<-128,0,0> <128,0,0> 1/32 pigment {rgb <1,0,0>} finish {ambient 1}}
//cylinder {<0,-128,0> <0,128,0> 1/32 pigment {rgb <0,1,0>} finish {ambient 1}}
//cylinder {<0,0,-128> <0,0,128> 1/32 pigment {rgb <0,0,1>} finish {ambient 1}}

camera {
 spherical
 location <0,0,0>
 look_at <1,0,0>
}


//"There are 10 types of people in the world... those who know binary and those who don't"
